--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- 
--- @class tes3processManager
--- @field aiDistance number A value which controls how far the game AI is processed, measured in game distance units. Corresponds to AI Distance slider in Options menu.
--- @field aiDistanceScale number A value which controls how far the game AI is processed. Corresponds to AI Distance slider in Options menu. This scale is in range [0, 1]. Where `0` means the minimal AI processing range, while `1` means maximal AI processing range.
--- @field allMobileActors tes3mobileActor[]|tes3mobileCreature[]|tes3mobileNPC[]|tes3mobilePlayer[] *Read-only*. A copy of the list of mobiles with currently running AI. This does not include the player. The available objects are only valid at a point in time, and maybe be deleted or re-used any time a mobile is moved or disabled, so this data should only be used in the same moment that it is read. This is not a lightweight accessor, so it should be used carefully.
--- @field allPlanners tes3aiPlanner[] *Read-only*. A copy of the list of currently running AI planners. This does not include the player. The available objects are only valid at a point in time, and maybe be deleted or re-used any time a mobile is moved or disabled, so this data should only be used in the same moment that it is read. This is not a lightweight accessor, so it should be used carefully.
tes3processManager = {}

--- 
--- @param actor tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer The actor to perform a check for.
--- @param container tes3aiPlanner Container is a actor's AI planner e.g. `mobile.aiPlanner`.
function tes3processManager:checkAlarmRadius(actor, container) end

--- Performs a check whether any potential nearby enemies allow the player to rest.
--- @return boolean result No description yet available.
function tes3processManager:checkNearbyEnemiesAllowRest() end

--- Forces a new distance check for actor AI behaviour.
function tes3processManager:checkPlayerDistance() end

--- This function performs a check for presence of a given mobile actor.
--- @param actor tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer The actor to perform a check for.
--- @param ignoreCreatures? boolean *Default*: `true`. No description yet available.
--- @return boolean result No description yet available.
function tes3processManager:detectPresence(actor, ignoreCreatures) end

--- This function performs a check whether a detector can detect another actor sneaking.
--- @param detector tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer The detector actor to perform a check for.
--- @param target tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer The target actor to perform a check for.
--- @param unknown? boolean *Default*: `true`. No description yet available.
--- @return boolean isDetected No description yet available.
function tes3processManager:detectSneak(detector, target, unknown) end

